(import (chicken format)
        zmq srfi-18)

;; server keypair
(define-values (spk ssk)
  (curve-keypair))

;; client keypair
(define-values (cpk csk)
  (curve-keypair))

(define (spin-server)
  (thread-start!
   (lambda ()
     (let ((socket (make-socket 'rep)))
       (socket-option-set! socket 'curve/server 1)
       (socket-option-set! socket 'curve/secretkey ssk)
       (printf "Server socket setup!~n")
       (bind-socket socket "tcp://*:5050")
       (let ((msg (receive-message* socket)))
         (printf "Received ~a, responding.~n" msg)
         (send-message socket "pong!")
         (close-socket socket))))))

(define (hit-server msg)
  (let ((socket (make-socket 'req)))
    (socket-option-set! socket 'curve/serverkey spk)
    (socket-option-set! socket 'curve/secretkey csk)
    (socket-option-set! socket 'curve/pubkey cpk)
    (connect-socket socket "tcp://192.168.0.7:5050")
    (send-message socket msg)
    (printf "Sent message, waiting for response...~n")
    (printf "Got response: ~a~n" (receive-message* socket))
    (close-socket socket)))
