(define (xdg-path env-variable fallback path)
  (let ((base (get-environment-variable env-variable)))
    (if (and base (eqv? (string-ref base 0) #\/))
        (string-append base path)
        (string-append fallback path))))

(define (xdg-config-path path)
  (let ((home (get-environment-variable "HOME")))
    (xdg-path "XDG_CONFIG_HOME" (string-append home "/.config"))))

(define (xdg-cache-path path)
  (let ((home (get-environment-variable "HOME")))
    (xdg-path "XDG_CACHE_HOME" (string-append home "/.cache"))))
