;;debug.scm

(require-extension r7rs)

(define r #t)

(define test (lambda ()
	(if r
		(begin
			(set! r #f)
			(define v 123)
			(test)
			(display v)
			(newline)
		)
		(begin
			(define v 234)
		)
	)
))

(test)

;; output: 234

;; The question is: Each time a procedure or partial block (like "let") is called, a closure should be created. Variables defined inside a closure should have a limited scope inside the closure unless "call/cc" or "call-with-values" is used. In the case above, none of them is used but the variable "v" survives beyond its closure created by "test" the 2nd time.

;; Further more, I found that only when "begin" is used will this bug appear.