(use srfi-69)

(define NODES 250000)
(define EDGES 1000)

(define graph (make-hash-table))

(define (insert-edges)
  (printf "~N Hash-tables - Inserting edges ~N")
  (do ((n 1 (+ n 1))) ((= n NODES))
    (if (= (remainder n 5000) 0)
        (printf " ~S nodes inserted ~N" n))
    (do ((e 2 (+ e 1))) ((= e (+ 1 EDGES)))
      (hash-table-update!/default graph
                                  n
                                  (lambda (edges-list)
                                    (if (member e edges-list)
                                        edges-list
                                        (cons e edges-list)))
                                  (list e)))))

(time  (insert-edges))
