(use srfi-18 tcp)

(define data (make-string 10))

(define threads
  (let loop ((i 0)) 
    (if (= 1000 i)
        '()
        (cons 
         (thread-start! 
          (lambda ()
            (receive (in out) (tcp-connect "localhost" 8080)
              (display data out)
              (flush-output out)
              (read-string 10 in)
              (close-output-port out)
              (close-input-port in))))
         (loop (+ i 1))))))



(let loop ((threads threads))
  (unless (null? threads)
    (thread-join! (car threads))
    (loop (cdr threads))))