#!/usr/local/bin/csi -s
; vim:filetype=chicken expandtab tabstop=2 textwidth=76:

(use posix qt-light utils)

(define *app* (qt:init))

(define *window* (qt:widget #<<TIMER
<?xml version="1.0" encoding="UTF-8"?>
<ui version="4.0">
 <class>Form</class>
 <widget class="QWidget" name="Form">
  <property name="geometry">
   <rect>
    <x>0</x>
    <y>0</y>
    <width>194</width>
    <height>149</height>
   </rect>
  </property>
  <property name="windowTitle">
   <string>Form</string>
  </property>
  <widget class="QPushButton" name="startButton">
   <property name="geometry">
    <rect>
     <x>20</x>
     <y>80</y>
     <width>80</width>
     <height>24</height>
    </rect>
   </property>
   <property name="text">
    <string>qt:start</string>
   </property>
  </widget>
  <widget class="QLCDNumber" name="lcdNumber">
   <property name="geometry">
    <rect>
     <x>120</x>
     <y>80</y>
     <width>61</width>
     <height>61</height>
    </rect>
   </property>
   <property name="font">
    <font>
     <pointsize>9</pointsize>
    </font>
   </property>
   <property name="numDigits">
    <number>2</number>
   </property>
   <property name="digitCount">
    <number>2</number>
   </property>
   <property name="intValue" stdset="0">
    <number>10</number>
   </property>
  </widget>
  <widget class="QLabel" name="label">
   <property name="geometry">
    <rect>
     <x>10</x>
     <y>10</y>
     <width>181</width>
     <height>51</height>
    </rect>
   </property>
   <property name="font">
    <font>
     <pointsize>13</pointsize>
    </font>
   </property>
   <property name="text">
    <string>Click stop or wait
for the time to run out</string>
   </property>
  </widget>
  <widget class="QPushButton" name="stopButton">
   <property name="geometry">
    <rect>
     <x>20</x>
     <y>110</y>
     <width>80</width>
     <height>24</height>
    </rect>
   </property>
   <property name="text">
    <string>qt:stop</string>
   </property>
  </widget>
 </widget>
 <resources/>
 <connections/>
</ui>
TIMER
))

;buttons
(define *start* (qt:find *window* "startButton"))
(define *stop*  (qt:find *window* "stopButton"))

;lcd number display
(define *lcd*   (qt:find *window* "lcdNumber"))

;Qt timer object
(define *ticker* (qt:timer 1))

;signal to fire upon each timeout 
(qt:connect
  *ticker* "timeout()"
  (qt:receiver
    (lambda ()
      (let ((seconds (qt:property *lcd* "intValue")))
        (cond
          ((< seconds 1)
		   (set! (qt:property *lcd* "intValue") 0)
		   (qt:stop *ticker*))
          (else
            (set! (qt:property *lcd* "intValue") (- seconds 1))))))))

(define (startButton)
  (qt:start *ticker*))

(define (stopButton)
  (qt:stop *ticker*))

(qt:connect *start* "clicked()" startButton)
(qt:connect *stop* "clicked()" stopButton)

(qt:show *window*)
(qt:run)
