(use posix test)

(define (set-file-mask! mask)
  (let ((test-file "foomask"))
    (delete-file* test-file)
    (set! (file-creation-mode) mask)
    (with-output-to-file test-file (cut print ""))
    (number->string (file-permissions test-file) 8)))

(test-begin "umask")
(test "100660" (set-file-mask! perm/irwxo))
(test "100600" (set-file-mask! (bitwise-ior perm/irwxo perm/irwxg)))
(test "100000" (set-file-mask! (bitwise-ior perm/irwxo perm/irwxg perm/irwxu)))

(test "100664" (set-file-mask! perm/iwoth))
(test "100644" (set-file-mask! (bitwise-ior perm/iwoth perm/iwgrp)))
(test "100444" (set-file-mask! (bitwise-ior perm/iwoth perm/iwgrp perm/iwusr)))
(test-end "umask")
