(import coops (chicken format))

(define-class <rect> () ((x 0.0) (y 0.0) (w 10.0) (h 10.0) (children '())))

(define-method (print-object (o <rect>) port)
	(fprintf port "~ax~a~a~a~a~a"  (slot-value o 'w) (slot-value o 'h)
		(if (>= (slot-value o 'x) 0) "+" "") (slot-value o 'x) (if (>= (slot-value o 'y) 0) "+" "") (slot-value o 'y) ))

;; lifted from dscm; overkill for this example
; (define-generic (->impl o . slots))
(define-method (->impl (obj <standard-object>) . slots)
	(let loop ([s slots][o obj])
		(cond
			[(not o) #f]
			[(promise? o) (loop s (force o))]
			[(procedure? o)
				(loop s (o))]
			[(null? s)
				o]
			[else
				(loop
					(cdr s)
					(let ([ref (car s)])
						(cond
							[(symbol? ref)
								(if (slot-initialized? o ref)
									(slot-value o ref)
									#f)]
							[(integer? ref)
								(cond
									[(vector? o) (vector-ref o ref)]
									[(pair? o) (list-ref o ref)] )]
									[else (printf "-> failed to reference ~a in ~a~%" ref o)])))])))

(define-syntax -> (syntax-rules () [(_ ?obj ?slot ...) (->impl ?obj '?slot ...) ]))

;; normal usage: colons look good in a constructor
(define r (make <rect> w: 100 h: 200 children: '("whatever" "is" "wanted" "here")))

;; colons don't look good in accessors: you can leave them out when using the -> syntax; otherwise, slot-value works as before
(printf "here's my rectangle ~a; its width is ~a and height is ~a; third child is ~s~%" r (-> r  w) (slot-value r 'h) (-> r  children 3))
