(import (chicken base))

(define-syntax let-optionals*
  (syntax-rules ()
    ((_ expr (binding ... . rest))
     '((expression expr)
       (bindings binding ...)
       (other . rest)))))

(print
 (let-optionals* _
                 ((foo 1)
                  (bar 2)
                  . baz)))
;; Error: during expansion of (syntax-rules ...) - Cannot combine dotted tail and ellipsis: (binding ... . rest)

(define-syntax apply-syntactic-continuation
  (syntax-rules ()
    ((apply-syntactic-continuation (?k ?env ...) . ?args)
     (?k ?env ... . ?args))))

(print (apply-syntactic-continuation (list 1 2 3) 4 5 6))
;; (list 1 2 3 4 5 6)
