(import scheme chicken)

(define assq-val-no-warning (lambda (sym lst)
  (let ((el (assq sym lst)))
    (if (list? el)
      (if (fx< 1 (length el))
        (cadr el)
        #f)
      (if (pair? el)          
        (cdr el)
        #f)))))


(define assq-val-warning (lambda (sym lst)
  (let ((el (assq sym lst)))
    (if (pair? el)
      (if (list? el)
        (if (fx< 1 (length el))
          (cadr el)
          #f)
        (cdr el)) ; <== compiler warning
      #f))))

(define assq-val-also-no-warning (lambda (sym lst)
  (define el (assq sym lst))
  (if (pair? el)
    (if (list? el)
      (if (fx< 1 (length el))
        (cadr el)
        #f)
      (cdr el))
    #f)))

(print (assq-val-no-warning 'a '((a "a")))) ; => "a"
(print (assq-val-no-warning 'a '((a . "a")))) ; => "a"
(print (assq-val-no-warning 'b '((a . "a")))) ; => #f

(print (assq-val-warning 'a '((a "a")))) ; => "a"
(print (assq-val-warning 'a '((a . "a")))) ; => "a"
(print (assq-val-warning 'b '((a . "a")))) ; => #f

(print (assq-val-also-no-warning 'a '((a "a")))) ; => "a"
(print (assq-val-also-no-warning 'a '((a . "a")))) ; => "a"
(print (assq-val-also-no-warning 'b '((a . "a")))) ; => #f
