CHICKEN_PLATFORM="${CHICKEN_PLATFORM:-linux}"
TEMPDIR=`pwd`/ckn-bug-tmp

rm -rf $TEMPDIR
mkdir -p $TEMPDIR
cd $TEMPDIR

echo "DOWNLOADING..."
wget https://code.call-cc.org/releases/4.13.0/chicken-4.13.0.tar.gz

echo "SETTING UP SVN..."
if [ -n "$GIT" ]
then
    git init svn-repo
    cd svn-repo
    git config receive.denyCurrentBranch ignore
    cd ..
    git clone file://`pwd`/svn-repo svn-trunk
    cd svn-trunk
    git branch master
    tar xzf ../chicken-4.13.0.tar.gz
    git add --all
    git commit -m "Test commit."
    git push
    rm -rf chicken-4.13.0
    git reset --hard
    cd ..
else
    svnadmin create svn-repo
    svn co file://`pwd`/svn-repo/ svn-trunk
    cd svn-trunk
    tar xzf ../chicken-4.13.0.tar.gz
    svn add chicken-4.13.0
    svn commit -m "Test commit."
    rm -rf chicken-4.13.0
    svn up chicken-4.13.0
    cd ..
fi

echo "SETTING UP TARBALL..."
tar xzf chicken-4.13.0.tar.gz

echo "DIFFERENCES:"
diff -rq chicken-4.13.0 svn-trunk/chicken-4.13.0

echo "RUNNING SVN..."
cd svn-trunk/chicken-4.13.0
make PLATFORM=$CHICKEN_PLATFORM PREFIX=inst &> $TEMPDIR/log-svn.txt
echo "DONE. EXIT STATUS: $?"
cd ../..

echo "RUNNING TARBALL..."
cd chicken-4.13.0
make PLATFORM=$CHICKEN_PLATFORM PREFIX=inst &> $TEMPDIR/log-tarball.txt
echo "DONE. EXIT STATUS: $?"
cd ..

echo "ALL DONE. See ckn-bug-tmp/log-tarball.txt and ckn-bug-tmp/log-svn.txt for details."
